#include "SGAffichage.h"

SGAffichage *SGAffichage::m_pSGAffichage=0;

SGAffichage::SGAffichage()
{ 
    printf("Dans constructeur SGAffichage\n");
    m_pSGAffichage=this ; 
}

SGAffichage::SGAffichage(const short int iLargeur,const short int iHauteur,
                        const char cCouleur,ModeAffichage mode,TypeAffichage type)
{ 
    printf("Dans constructeur SGAffichage\n");
    m_pSGAffichage=this ; 
    m_iHauteur=iHauteur;
    m_iLargeur=iLargeur;
    m_cCouleur=cCouleur;
    m_Mode=mode;
    m_Type=type;
    m_iPage=0;
    m_bTemps=false;
    m_bFps=false;
    m_iFps=0;
    m_iCptFps=0;
}

SGAffichage::~SGAffichage()
{
    printf("Dans Destructeur SGAffichage\n");
    if ( m_Type == DOUBLEBUFFERING )
    {
        destroy_bitmap(m_pTemp[0]);
    }
    else if ( m_Type == PAGEFLIPING )
    {
        destroy_bitmap(m_pTemp[0]);
        destroy_bitmap(m_pTemp[1]);        
    }
    else if ( m_Type == TRIPLEBUFFERING )
    {
        destroy_bitmap(m_pTemp[0]);
        destroy_bitmap(m_pTemp[1]);
        destroy_bitmap(m_pTemp[2]);
    }
}

void SGAffichage::initialiser()
{
    set_color_depth(m_cCouleur);
    
    if ( m_Mode == WINDOWED )
        set_gfx_mode(GFX_AUTODETECT_WINDOWED,m_iLargeur,m_iHauteur,0,0);
    else
        set_gfx_mode(GFX_AUTODETECT,m_iLargeur,m_iHauteur,0,0);
    
    if ( m_Type == DOUBLEBUFFERING )
    {
        m_pTemp[0]=create_bitmap(m_iLargeur,m_iHauteur);
    }
    else if ( m_Type == PAGEFLIPING )
    {
        m_pTemp[0]=create_video_bitmap(m_iLargeur,m_iHauteur);
        m_pTemp[1]=create_video_bitmap(m_iLargeur,m_iHauteur);
    }
    else if ( m_Type == TRIPLEBUFFERING )
    {
	    enable_triple_buffer();
        m_pTemp[0]=create_video_bitmap(m_iLargeur,m_iHauteur);
        m_pTemp[1]=create_video_bitmap(m_iLargeur,m_iHauteur);
        m_pTemp[2]=create_video_bitmap(m_iLargeur,m_iHauteur);
    }
    // Pour que les fonts soient transparentes
    text_mode(-1);    
    
    PALETTE pal;

    create_trans_table(&m_transTable, pal, 128, 128, 128, NULL);
    color_map=&m_transTable;
    /* select translucency blender */
    set_trans_blender(0, 0, 0, 128);
}

void SGAffichage::effacerTout()
{
    clear_bitmap(m_pTemp[m_iPage]);
}

void SGAffichage::afficherTout()
{
    if ( m_bTemps ) chargerTemps();
    if ( m_bFps ) chargerFps();
    if ( m_Type == DOUBLEBUFFERING )
    {
        blit(m_pTemp[m_iPage],screen,0,0,0,0,SCREEN_W,SCREEN_H);
    }
    else if ( m_Type == PAGEFLIPING )
    {
        show_video_bitmap(m_pTemp[m_iPage]);
        m_iPage=1-m_iPage;
    }
    else if ( m_Type == TRIPLEBUFFERING )
    {
	    do {
	    } while (poll_scroll());

	    request_video_bitmap(m_pTemp[m_iPage]);
	    m_iPage = (m_iPage+1)%3;
    }
    
}

void SGAffichage::chargerSprite(char *szNom)
{
    if ( g_SGEntite.get(szNom)->getSprite() != NULL )
         g_SGEntite.get(szNom)->getSprite()->charger(&m_pTemp[m_iPage],g_SGEntite.get(szNom)->getX(),
                                    g_SGEntite.get(szNom)->getY() );
}

void SGAffichage::chargerSprites()
{
    if ( g_SGEntite.getSizeListe() > 0 )
    {
        g_SGEntite.debut();
        do
        {
            if ( g_SGEntite.getCourant()->getSprite() != NULL )
                 g_SGEntite.getCourant()->getSprite()->charger(&m_pTemp[m_iPage],
                      g_SGEntite.getCourant()->getX(),g_SGEntite.getCourant()->getY() );
        } while( g_SGEntite.suivant() );
    }
}

void SGAffichage::afficherTexte(char *szTexte,const int iX,const int iY,const int iColor)
{
    textout(m_pTemp[m_iPage],font,szTexte,iX,iY,iColor);
}

void SGAffichage::chargerTemps()
{
    textprintf(m_pTemp[m_iPage],font,10,10,2000,"Temps du jeu: %d ms",g_SGTimer.getTimer());
}

void SGAffichage::afficherEntier(const int iEntier,const int iX,const int iY,const int iColor)
{
    textprintf(m_pTemp[m_iPage],font,iX,iY,iColor,"%d",iEntier);
}

void SGAffichage::afficherFps()
{
    m_bFps=true;
    g_SGTimer.add("fps",1000);
}

void SGAffichage::effacerFps()
{
    m_bFps=false;
    g_SGTimer.del("fps");
}

void SGAffichage::chargerFps()
{
    m_iCptFps++;
    if ( g_SGTimer.get("fps")->pret() )
    {
        m_iFps=m_iCptFps;
        m_iCptFps=0;
    }
    textprintf(m_pTemp[m_iPage],font,screen->w-70,10,2000,"Fps: %d",m_iFps);
}

void SGAffichage::animerSprites()
{
    if ( g_SGEntite.getSizeListe() > 0 )
    {
        g_SGEntite.debut();
        do
        {
             if ( g_SGEntite.getCourant()->getSprite() != NULL )
                 g_SGEntite.getCourant()->getSprite()->runAnimer();
        } while( g_SGEntite.suivant() );
    }
}
